"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrebuiltRuleAssetsFilter = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// API design document (internal): https://docs.google.com/document/d/1AYlt8wJMoLD-V_owAd4qL-h76IOVnfDCZ77VNmmf-Ks

const PrebuiltRuleAssetsFilter = exports.PrebuiltRuleAssetsFilter = _zod.z.object({
  fields: _zod.z.object({
    name: _zod.z.object({
      include: _zod.z.object({
        values: _zod.z.array(_zod.z.string())
      }).optional(),
      exclude: _zod.z.object({
        values: _zod.z.array(_zod.z.string())
      }).optional()
    }).optional(),
    tags: _zod.z.object({
      include: _zod.z.object({
        values: _zod.z.array(_zod.z.string())
      }).optional(),
      exclude: _zod.z.object({
        values: _zod.z.array(_zod.z.string())
      }).optional()
    }).optional()
  })
});