"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEntityAnalyticsNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEntityAnalyticsNavigationTree = () => ({
  id: _constants.SecurityGroupName.entityAnalytics,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.entityAnalytics].title,
  renderAs: 'panelOpener',
  children: [{
    id: _constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring,
    link: (0, _links.securityLink)(_constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring)
  }]
});
exports.createEntityAnalyticsNavigationTree = createEntityAnalyticsNavigationTree;