"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsellingSections = exports.upsellingPages = exports.upsellingMessages = exports.registerUpsellings = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _messages = require("@kbn/security-solution-upselling/messages");
var _services = require("../common/services");
var _lazy_upselling = require("./lazy_upselling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUpsellings = (upselling, license, services) => {
  const upsellingPagesToRegister = upsellingPages.reduce((pageUpsellings, {
    pageName,
    minimumLicenseRequired,
    component
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      pageUpsellings[pageName] = (0, _services.withServicesProvider)(component, services);
    }
    return pageUpsellings;
  }, {});
  const upsellingSectionsToRegister = upsellingSections.reduce((sectionUpsellings, {
    id,
    minimumLicenseRequired,
    component
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      sectionUpsellings[id] = (0, _services.withServicesProvider)(component, services);
    }
    return sectionUpsellings;
  }, {});
  const upsellingMessagesToRegister = upsellingMessages.reduce((messagesUpsellings, {
    id,
    minimumLicenseRequired,
    message
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      messagesUpsellings[id] = message;
    }
    return messagesUpsellings;
  }, {});
  upselling.setPages(upsellingPagesToRegister);
  upselling.setSections(upsellingSectionsToRegister);
  upselling.setMessages(upsellingMessagesToRegister);
};

// Upsellings for entire pages, linked to a SecurityPageName
exports.registerUpsellings = registerUpsellings;
const upsellingPages = exports.upsellingPages = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  pageName: _common.SecurityPageName.entityAnalytics,
  minimumLicenseRequired: 'platinum',
  component: _lazy_upselling.EntityAnalyticsUpsellingPageLazy
}, {
  pageName: _common.SecurityPageName.attackDiscovery,
  minimumLicenseRequired: 'enterprise',
  component: _lazy_upselling.AttackDiscoveryUpsellingPageLazy
}, {
  pageName: _common.SecurityPageName.siemMigrationsRules,
  minimumLicenseRequired: 'enterprise',
  component: _lazy_upselling.SiemMigrationsTranslatedRulesUpsellPageLazy
}];

// Upsellings for sections, linked by arbitrary ids
const upsellingSections = exports.upsellingSections = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  id: 'entity_analytics_panel',
  minimumLicenseRequired: 'platinum',
  component: _lazy_upselling.EntityAnalyticsUpsellingSectionLazy
}, {
  id: 'siem_migrations_start',
  minimumLicenseRequired: 'enterprise',
  component: _lazy_upselling.SiemMigrationsStartUpsellSectionLazy
}];

// Upsellings for sections, linked by arbitrary ids
const upsellingMessages = exports.upsellingMessages = [{
  id: 'investigation_guide',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.UPGRADE_INVESTIGATION_GUIDE)('Platinum')
}, {
  id: 'alert_assignments',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.UPGRADE_ALERT_ASSIGNMENTS)('Platinum')
}, {
  id: 'alert_suppression_rule_form',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.ALERT_SUPPRESSION_RULE_FORM)('Platinum')
}, {
  id: 'alert_suppression_rule_details',
  minimumLicenseRequired: 'platinum',
  message: _messages.ALERT_SUPPRESSION_RULE_DETAILS
}, {
  id: 'note_management_user_filter',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.UPGRADE_NOTES_MANAGEMENT_USER_FILTER)('Platinum')
}, {
  id: 'prebuilt_rule_customization',
  minimumLicenseRequired: 'enterprise',
  message: (0, _messages.PREBUILT_RULE_CUSTOMIZATION)('Enterprise', 'subscription')
}, {
  id: 'prebuilt_rule_customization_description',
  minimumLicenseRequired: 'enterprise',
  message: (0, _messages.PREBUILT_RULE_CUSTOMIZATION_DESCRIPTION)('Enterprise', 'subscription')
}];