"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePassword = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../../common/model");
var _change_password_form = require("../../management/users/components/change_password_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ChangePassword extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getChangePasswordForm", changePasswordTitle => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        fullWidth: true,
        title: /*#__PURE__*/_react.default.createElement("h2", null, changePasswordTitle),
        description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.account.changePasswordDescription",
          defaultMessage: "Change the password for your account."
        }))
      }, /*#__PURE__*/_react.default.createElement(_change_password_form.ChangePasswordForm, {
        user: this.props.user,
        isUserChangingOwnPassword: true,
        userAPIClient: this.props.userAPIClient,
        notifications: this.props.notifications
      }));
    });
  }
  render() {
    const canChangePassword = (0, _model.canUserChangePassword)(this.props.user);
    const changePasswordTitle = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.account.changePasswordTitle",
      defaultMessage: "Password"
    });
    if (canChangePassword) {
      return this.getChangePasswordForm(changePasswordTitle);
    }
    return this.getChangePasswordUnavailable(changePasswordTitle);
  }
  getChangePasswordUnavailable(changePasswordTitle) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      fullWidth: true,
      title: /*#__PURE__*/_react.default.createElement("h3", null, changePasswordTitle),
      description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.account.changePasswordNotSupportedText",
        defaultMessage: "You cannot change the password for this account."
      }))
    }, /*#__PURE__*/_react.default.createElement("div", null));
  }
}
exports.ChangePassword = ChangePassword;