"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSessionExpirationModal = exports.SessionExpirationModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SessionExpirationModal = ({
  sessionState$,
  onExtend,
  onClose
}) => {
  const state = (0, _useObservable.default)(sessionState$);
  const [{
    loading
  }, extend] = (0, _useAsyncFn.default)(onExtend);
  if (!state || !state.expiresInMs) {
    return null;
  }
  const timeoutSeconds = Math.max(state.expiresInMs - _constants.SESSION_GRACE_PERIOD_MS, 0) / 1000;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    initialFocus: "[data-test-subj=session-expiration-extend-button]",
    role: "dialog",
    "aria-labelledby": "session-expiration-modal-title"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: "session-expiration-modal-title"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "clock",
    color: "warning",
    size: "l",
    style: {
      marginRight: 8
    }
  }), _i18n.i18n.translate('xpack.security.sessionExpirationModal.title', {
    defaultMessage: 'Session timeout'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.sessionExpirationModal.body",
    defaultMessage: "You will be logged out {timeout}. Please save your work and log in again.",
    values: {
      timeout: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
        value: timeoutSeconds,
        updateIntervalInSeconds: 1
      })
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    isLoading: loading,
    onClick: extend,
    "data-test-subj": "session-expiration-extend-button",
    autoFocus: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.sessionExpirationModal.extendButton",
    defaultMessage: "Stay logged in"
  })))));
};
exports.SessionExpirationModal = SessionExpirationModal;
const createSessionExpirationModal = (services, sessionState$, onExtend, onClose) => {
  return (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(SessionExpirationModal, {
    sessionState$: sessionState$,
    onExtend: onExtend,
    onClose: onClose
  }), services);
};
exports.createSessionExpirationModal = createSessionExpirationModal;