"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDelete = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConfirmDelete extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onConfirmDelete", () => {
      this.setState({
        deleteInProgress: true
      }, () => {
        this.deleteRoles();
      });
    });
    (0, _defineProperty2.default)(this, "deleteRoles", async () => {
      const {
        rolesToDelete,
        callback,
        rolesAPIClient,
        notifications,
        buildFlavor
      } = this.props;
      const errors = [];
      const deleteOperations = rolesToDelete.map(roleName => {
        const deleteRoleTask = async () => {
          try {
            await rolesAPIClient.deleteRole(roleName);
            if (buildFlavor === 'traditional') {
              notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.roles.confirmDelete.roleSuccessfullyDeletedNotificationMessage', {
                defaultMessage: 'Deleted role {roleName}',
                values: {
                  roleName
                }
              }));
            }
          } catch (e) {
            errors.push(roleName);
            notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.roles.confirmDelete.roleDeletingErrorNotificationMessage', {
              defaultMessage: 'Error deleting role {roleName}',
              values: {
                roleName
              }
            }));
          }
        };
        return deleteRoleTask();
      });
      await Promise.all(deleteOperations);
      if (buildFlavor === 'serverless') {
        this.props.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.roles.deleteRolesSuccessTitle', {
            defaultMessage: '{numberOfCustomRoles, plural, one {# custom role} other {# custom roles}} deleted',
            values: {
              numberOfCustomRoles: deleteOperations.length
            }
          }),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.security.management.roles.deleteRolesSuccessMessage', {
            defaultMessage: `The deleted role will still appear listed on the user profile in Organization
                  Management and on the User Profile for those that don't have admin access.`
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            size: "s",
            href: this.props.cloudOrgUrl
          }, "Manage Members")))), this.props)
        });
      }
      callback(rolesToDelete, errors);
    });
    this.state = {
      deleteInProgress: false
    };
  }
  render() {
    const {
      rolesToDelete,
      buildFlavor
    } = this.props;
    const moreThanOne = rolesToDelete.length > 1;
    const title = _i18n.i18n.translate('xpack.security.management.roles.deleteRoleTitle', {
      defaultMessage: `Delete role{value, plural, one {{roleName}} other {s}}?`,
      values: {
        value: rolesToDelete.length,
        roleName: ` ${rolesToDelete[0]}`
      }
    });

    // This is largely the same as the built-in EuiConfirmModal component, but we needed the ability
    // to disable the buttons since this could be a long-running operation

    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.props.onCancel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      "data-test-subj": "confirmModalTitleText"
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, moreThanOne ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, buildFlavor === 'traditional' && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.removingRolesDescription",
      defaultMessage: "You are about to delete these roles:"
    })), buildFlavor === 'serverless' && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.serverless.removingRolesDescription",
      defaultMessage: "Users with the following roles assigned may lose access to the project if they are not assigned any other roles:"
    })), /*#__PURE__*/_react.default.createElement("ul", null, rolesToDelete.map(roleName => /*#__PURE__*/_react.default.createElement("li", {
      key: roleName
    }, roleName)))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, buildFlavor === 'serverless' && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.serverless.removingSingleRoleDescription",
      defaultMessage: "Users with the {roleName} role assigned may lose access to the project if they are not assigned any other roles.",
      values: {
        roleName: rolesToDelete[0]
      }
    }))), buildFlavor === 'traditional' && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.deletingRolesWarningMessage",
      defaultMessage: "You can't undo this operation."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "confirmModalCancelButton",
      onClick: this.props.onCancel,
      isDisabled: this.state.deleteInProgress
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "confirmModalConfirmButton",
      onClick: this.onConfirmDelete,
      fill: true,
      color: 'danger',
      isLoading: this.state.deleteInProgress
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.deleteButtonLabel",
      defaultMessage: "Delete"
    }))));
  }
}
exports.ConfirmDelete = ConfirmDelete;