"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRoleButton = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DeleteRoleButton extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showModal: false
    });
    (0, _defineProperty2.default)(this, "maybeShowModal", () => {
      const {
        buildFlavor,
        roleName
      } = this.props;
      if (!this.state.showModal) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: buildFlavor !== 'serverless' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.deleteRoleButton.deleteRoleTitle",
          defaultMessage: "Delete Role"
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editCustomRole.deleteRoleButton.deleteRoleTitle",
          defaultMessage: "Delete Role {roleName}?",
          values: {
            roleName
          }
        }),
        onCancel: this.closeModal,
        onConfirm: this.onConfirmDelete,
        cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.deleteRoleButton.cancelButtonLabel",
          defaultMessage: "No, don't delete"
        }),
        confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.deleteRoleButton.confirmButtonLabel",
          defaultMessage: "Yes, delete role"
        }),
        buttonColor: 'danger'
      }, /*#__PURE__*/_react.default.createElement("p", null, buildFlavor !== 'serverless' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.deleteRoleButton.deletingRoleConfirmationText",
        defaultMessage: "Are you sure you want to delete this role?"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roles.confirmDelete.serverless.removingSingleRoleDescription",
        defaultMessage: "Users with the {roleName} role assigned may lose access to the project if they are not assigned any other roles.",
        values: {
          roleName
        }
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.deleteRoleButton.deletingRoleWarningText",
        defaultMessage: "This action cannot be undone!"
      })));
    });
    (0, _defineProperty2.default)(this, "closeModal", () => {
      this.setState({
        showModal: false
      });
    });
    (0, _defineProperty2.default)(this, "showModal", () => {
      this.setState({
        showModal: true
      });
    });
    (0, _defineProperty2.default)(this, "onConfirmDelete", () => {
      this.closeModal();
      this.props.onDelete();
    });
  }
  render() {
    if (!this.props.canDelete) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: 'danger',
      onClick: this.showModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.deleteRoleButton.deleteRoleButtonLabel",
      defaultMessage: "Delete role"
    })), this.maybeShowModal());
  }
}
exports.DeleteRoleButton = DeleteRoleButton;