"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadonlyBadge = void 0;
var _i18n = require("@kbn/i18n");
var _use_badge = require("../../components/use_badge");
var _use_capabilities = require("../../components/use_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReadonlyBadge = ({
  featureId,
  tooltip
}) => {
  const {
    save
  } = (0, _use_capabilities.useCapabilities)(featureId);
  (0, _use_badge.useBadge)(save ? undefined : {
    iconType: 'glasses',
    text: _i18n.i18n.translate('xpack.security.management.readonlyBadge.text', {
      defaultMessage: 'Read only'
    }),
    tooltip
  }, [save]);
  return null;
};
exports.ReadonlyBadge = ReadonlyBadge;