"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchProfilerTabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchProfilerTabs = ({
  activeTab,
  activateTab,
  has
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "queryProfileTab",
    isSelected: activeTab === 'searches',
    disabled: !has.searches,
    onClick: () => activateTab('searches')
  }, _i18n.i18n.translate('xpack.searchProfiler.queryProfileTabTitle', {
    defaultMessage: 'Query Profile'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "aggregationProfileTab",
    isSelected: activeTab === 'aggregations',
    disabled: !has.aggregations,
    onClick: () => activateTab('aggregations')
  }, _i18n.i18n.translate('xpack.searchProfiler.aggregationProfileTabTitle', {
    defaultMessage: 'Aggregation Profile'
  })));
};
exports.SearchProfilerTabs = SearchProfilerTabs;