"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSynonymsSet = void 0;
var _pagination = require("../../common/pagination");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSynonymsSet = async (client, synonymsSetId, {
  from,
  size
}) => {
  const result = await client.synonyms.getSynonym({
    id: synonymsSetId,
    from,
    size
  });
  const _meta = (0, _pagination.pageToPagination)({
    from,
    size,
    total: result.count
  });
  return {
    _meta,
    id: synonymsSetId,
    data: result.synonyms_set
  };
};
exports.fetchSynonymsSet = fetchSynonymsSet;