"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymsSetEmptyRulesCards = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SynonymsSetEmptyRulesCards = ({
  onCreateRule
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
          min-width: ${euiTheme.base * 24}px;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    textAlign: "left",
    title: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.title', {
      defaultMessage: 'Equivalent'
    }),
    description: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.description', {
      defaultMessage: 'Interchangeable words that will match each other.'
    }),
    footer: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      "data-test-subj": "searchSynonymsSynonymsSetEmptyRulesCardsAddEquivalentRuleButton",
      color: "primary",
      onClick: () => onCreateRule('equivalent')
    }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.addRuleButton', {
      defaultMessage: 'Add equivalent rule'
    }))))
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.example.computer', {
    defaultMessage: 'computer'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.example.laptop', {
    defaultMessage: 'laptop'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.example.pc', {
    defaultMessage: 'pc'
  })))))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
          min-width: ${euiTheme.base * 24}px;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    hasBorder: true,
    title: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.explicit.title', {
      defaultMessage: 'Explicit'
    }),
    description: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.explicit.description', {
      defaultMessage: 'Words that expand to include the terms on the right.'
    }),
    footer: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      "data-test-subj": "searchSynonymsSynonymsSetEmptyRulesCardsAddExplicitRuleButton",
      color: "primary",
      onClick: () => onCreateRule('explicit')
    }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.explicit.addRuleButton', {
      defaultMessage: 'Add explicit rule'
    }))))
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.explicit.example.jacket', {
    defaultMessage: 'jacket'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.example.parka', {
    defaultMessage: 'parka'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react2.default.createElement("b", null, '=>'))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetEmptyRulesCards.equivalent.example.coat', {
    defaultMessage: 'coat'
  })))))))));
};
exports.SynonymsSetEmptyRulesCards = SynonymsSetEmptyRulesCards;