"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectToApiFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../common/doc_links");
var _code_examples = require("./code_examples");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectToApiFlyout = ({
  onClose,
  rulesetId
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.title', {
    defaultMessage: 'Connect with the API'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.description', {
    defaultMessage: 'You can access and manage this synonym set from the API.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchSynonymsConnectToApiFlyoutViewFullApiReferenceLink",
    href: _doc_links.docLinks.synonymsApi,
    external: true
  }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.viewFullApiReference', {
    defaultMessage: 'View full API reference'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.description', {
    defaultMessage: `You can specify the analyzer that contains your synonyms set as a search time analyzer.`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.description.example', {
    defaultMessage: `The following example adds my_analyzer as a search analyzer to the title field in an index mapping`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "connectToIndexNewIndexAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.exampleButton.newIndex', {
      defaultMessage: 'Assigning to a new index'
    }))),
    initialIsOpen: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    fontSize: "m"
  }, (0, _code_examples.getExampleCode)(rulesetId)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "connectToIndexExistingIndexAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.exampleButton.existingIndex', {
      defaultMessage: 'Assigning to an existing index'
    }))),
    initialIsOpen: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    fontSize: "m"
  }, (0, _code_examples.getExistingIndexExampleCode)(rulesetId))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "searchSynonymsConnectToApiFlyoutButton",
    onClick: onClose
  }, _i18n.i18n.translate('xpack.searchSynonyms.ConnectToApiFlyout.close', {
    defaultMessage: 'Close'
  }))))));
};
exports.ConnectToApiFlyout = ConnectToApiFlyout;