"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExistingIndexExampleCode = exports.getExampleCode = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExampleCode = rulesetId => `
PUT my-index
{
  "mappings": {
    "properties": {
      "title": {
        "type": "text",
        "search_analyzer": "my_analyzer"
      }
    }
  },
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "whitespace",
          "filter": [
            "synonyms_filter"
          ]
        }
      },
      "filter": {
        "synonyms_filter": {
          "type": "synonym",
          "synonyms_set": "${rulesetId}",
          "updateable": true
        }
      }
    }
  }
}`;
exports.getExampleCode = getExampleCode;
const getExistingIndexExampleCode = rulesetId => `
POST my-index/_close

PUT my-index/_settings
{
  "analysis": {
    "analyzer": {
      "my_analyzer": {
        "tokenizer": "whitespace",
        "filter": [
          "synonyms_filter"
        ]
      }
    },
    "filter": {
      "synonyms_filter": {
        "type": "synonym",
        "synonyms_set": "${rulesetId}",
        "updateable": true
      }
    }
  }
}

PUT my-index/_mapping
{
  "properties": {
    "title": {
      "type": "text",
      "search_analyzer": "my_analyzer"
    }
  }
}

POST my-index/_open
`;
exports.getExistingIndexExampleCode = getExistingIndexExampleCode;