"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleDraggableListItem = exports.QueryRuleDraggableList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_usage_tracker = require("../../../hooks/use_usage_tracker");
var _styles = require("../styles");
var _query_rule_draggable_list_header = require("./query_rule_draggable_list_header");
var _query_rule_list_item_content = require("./query_rule_list_item_content");
var _constants = require("../../../analytics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRuleDraggableListItem = ({
  index,
  rulesetId,
  rules,
  onEditRuleFlyoutOpen,
  deleteRule,
  queryRule,
  tourInfo,
  isLastItem = false
}) => {
  const localTourTargetRef = (0, _react.useRef)(null);
  const effectiveRef = (tourInfo === null || tourInfo === void 0 ? void 0 : tourInfo.tourTargetRef) || localTourTargetRef;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    key: queryRule.rule_id,
    index: index,
    draggableId: queryRule.rule_id,
    customDragHandle: true,
    hasInteractiveChildren: true,
    "data-test-subj": "searchQueryRulesDraggableItem"
  }, provided => /*#__PURE__*/_react.default.createElement(_query_rule_list_item_content.QueryRuleListItemContent, {
    rules: rules,
    queryRule: queryRule,
    rulesetId: rulesetId,
    onEditRuleFlyoutOpen: onEditRuleFlyoutOpen,
    deleteRule: deleteRule,
    order: index + 1,
    isDraggable: true,
    dragHandleProps: provided.dragHandleProps,
    tourTargetRef: isLastItem ? effectiveRef : undefined
  }));
};
exports.QueryRuleDraggableListItem = QueryRuleDraggableListItem;
const QueryRuleDraggableList = ({
  rules,
  rulesetId,
  onEditRuleFlyoutOpen,
  deleteRule,
  onReorder,
  tourInfo
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: ({
      source,
      destination
    }) => {
      if (source && destination) {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.rulesReordered);
        const items = (0, _eui.euiDragDropReorder)(rules, source.index, destination.index);
        onReorder(items);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_list_header.QueryRuleDraggableListHeader, {
    tourInfo: tourInfo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "queryRuleListDropabble",
    spacing: "m",
    css: (0, _styles.DroppableContainer)(euiTheme),
    "data-test-subj": "searchQueryRulesDroppable"
  }, rules.map((queryRule, index) => /*#__PURE__*/_react.default.createElement(QueryRuleDraggableListItem, {
    key: queryRule.rule_id,
    queryRule: queryRule,
    deleteRule: deleteRule,
    rulesetId: rulesetId,
    tourInfo: tourInfo,
    index: index,
    rules: rules,
    "data-test-subj": `searchQueryRulesDraggableItem-${queryRule.rule_id}`,
    onEditRuleFlyoutOpen: onEditRuleFlyoutOpen,
    isLastItem: index === rules.length - 1
  })))));
};
exports.QueryRuleDraggableList = QueryRuleDraggableList;