"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleDraggableListItemActionTypeBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _styles = require("../styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRuleDraggableListItemActionTypeBadge = ({
  queryRule
}) => {
  var _queryRule$actions$do, _queryRule$actions$do2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "m",
    justifyContent: "center",
    css: (0, _styles.DocsColumnContainer)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _styles.ActionTypeIconBadgeContainer)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: queryRule.type === 'exclude' ? 'eyeClosed' : 'pinFilled'
  }, queryRule.type === 'exclude' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.draggableList.excludeLabel",
    defaultMessage: "Exclude"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.draggableList.pinLabel",
    defaultMessage: "Pin"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _styles.DocumentCountLabelContainer)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _styles.DocumentCountLabelStyle)(euiTheme)
  }, (_queryRule$actions$do = (_queryRule$actions$do2 = queryRule.actions.docs) === null || _queryRule$actions$do2 === void 0 ? void 0 : _queryRule$actions$do2.length) !== null && _queryRule$actions$do !== void 0 ? _queryRule$actions$do : 0))));
};
exports.QueryRuleDraggableListItemActionTypeBadge = QueryRuleDraggableListItemActionTypeBadge;