"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadFieldsByIndices = void 0;
var _react = require("react");
var _use_usage_tracker = require("./use_usage_tracker");
var _types = require("../types");
var _use_indices_fields = require("./use_indices_fields");
var _create_query = require("../utils/create_query");
var _constants = require("../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeDefaultAndCurrentValues = (defaultFields, currentFields) => Object.keys(defaultFields).reduce((result, key) => {
  var _currentFields$key;
  result[key] = (_currentFields$key = currentFields === null || currentFields === void 0 ? void 0 : currentFields[key]) !== null && _currentFields$key !== void 0 ? _currentFields$key : defaultFields[key];
  return result;
}, {});
const useLoadFieldsByIndices = ({
  watch,
  setValue,
  getValues
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const selectedIndices = watch(_types.ChatFormFields.indices);
  const {
    fields
  } = (0, _use_indices_fields.useIndicesFields)(selectedIndices);
  (0, _react.useEffect)(() => {
    var _Object$values, _Object$values$flat;
    const [queryFields, sourceFields] = getValues([_types.ChatFormFields.queryFields, _types.ChatFormFields.sourceFields]);
    const defaultFields = (0, _create_query.getDefaultQueryFields)(fields);
    const defaultSourceFields = (0, _create_query.getDefaultSourceFields)(fields);
    const mergedQueryFields = mergeDefaultAndCurrentValues(defaultFields, queryFields);
    const mergedSourceFields = mergeDefaultAndCurrentValues(defaultSourceFields, sourceFields);
    setValue(_types.ChatFormFields.elasticsearchQuery, (0, _create_query.createQuery)(mergedQueryFields, mergedSourceFields, fields));
    setValue(_types.ChatFormFields.queryFields, mergedQueryFields);
    setValue(_types.ChatFormFields.sourceFields, mergedSourceFields);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.sourceFieldsLoaded, (_Object$values = Object.values(fields)) === null || _Object$values === void 0 ? void 0 : (_Object$values$flat = _Object$values.flat()) === null || _Object$values$flat === void 0 ? void 0 : _Object$values$flat.length);
  }, [fields, getValues, setValue, usageTracker]);
};
exports.useLoadFieldsByIndices = useLoadFieldsByIndices;