"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateIndexButton = () => {
  const {
    services: {
      application,
      share
    }
  } = (0, _use_kibana.useKibana)();
  const createIndexLocator = (0, _react.useMemo)(() => {
    var _share$url$locators$g;
    return (_share$url$locators$g = share.url.locators.get('CREATE_INDEX_LOCATOR_ID')) !== null && _share$url$locators$g !== void 0 ? _share$url$locators$g : share.url.locators.get('SEARCH_CREATE_INDEX');
  }, [share.url.locators]);
  const handleNavigateToIndex = (0, _react.useCallback)(async () => {
    const createIndexUrl = await (createIndexLocator === null || createIndexLocator === void 0 ? void 0 : createIndexLocator.getUrl({}));
    if (createIndexUrl) {
      application === null || application === void 0 ? void 0 : application.navigateToUrl(createIndexUrl);
    }
  }, [application, createIndexLocator]);
  return createIndexLocator ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "plusInCircle",
    fill: true,
    onClick: handleNavigateToIndex,
    "data-test-subj": "createIndexButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.createIndexButton",
    defaultMessage: "Create an index"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.searchPlayground.createIndexCallout', {
      defaultMessage: 'You need to create an index first'
    }),
    size: "s",
    color: "warning",
    "data-test-subj": "createIndexCallout"
  });
};
exports.CreateIndexButton = CreateIndexButton;