"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditContextPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _constants = require("../../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditContextPanel = () => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    fields
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const {
    field: {
      onChange: onChangeSize,
      value: docSize
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.docSize
  });
  const {
    field: {
      onChange: onChangeSourceFields,
      value: sourceFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.sourceFields
  });
  const updateSourceField = (index, field) => {
    onChangeSourceFields({
      ...sourceFields,
      [index]: [field]
    });
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextFieldToggled);
  };
  const handleDocSizeChange = e => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextDocSizeChanged);
    onChangeSize(Number(e.target.value));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "editContextPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchPlayground.editContext.docsRetrievedCount', {
      defaultMessage: 'Number of documents sent to LLM'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: [{
      value: 1,
      text: '1'
    }, {
      value: 3,
      text: '3'
    }, {
      value: 5,
      text: '5'
    }, {
      value: 10,
      text: '10'
    }],
    value: docSize,
    onChange: handleDocSizeChange,
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.table.title",
    defaultMessage: "Context fields"
  })))), Object.entries(fields).map(([index, group], indexNum) => {
    var _group$source_fields, _sourceFields$index;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: index,
      fullWidth: true
    }, !!((_group$source_fields = group.source_fields) !== null && _group$source_fields !== void 0 && _group$source_fields.length) ? /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      "data-test-subj": `contextFieldsSelectable-${indexNum}`,
      options: group.source_fields.map(field => ({
        value: field,
        inputDisplay: field,
        'data-test-subj': 'contextField'
      })),
      valueOfSelected: (_sourceFields$index = sourceFields[index]) === null || _sourceFields$index === void 0 ? void 0 : _sourceFields$index[0],
      onChange: value => updateSourceField(index, value),
      fullWidth: true
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.searchPlayground.editContext.noSourceFieldWarning', {
        defaultMessage: 'No source fields found'
      }),
      color: "warning",
      iconType: "warning",
      size: "s"
    })));
  })))));
};
exports.EditContextPanel = EditContextPanel;