"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatSidebar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _doc_links = require("../../common/doc_links");
var _edit_context_panel = require("./edit_context/edit_context_panel");
var _types = require("../types");
var _use_management_link = require("../hooks/use_management_link");
var _summarization_panel = require("./summarization_panel/summarization_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatSidebar = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectedModel = (0, _reactHookForm.useWatch)({
    name: _types.ChatFormFields.summarizationModel
  });
  const managementLink = (0, _use_management_link.useManagementLink)(selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.connectorId);
  const panels = [{
    title: _i18n.i18n.translate('xpack.searchPlayground.sidebar.summarizationTitle', {
      defaultMessage: 'Model settings'
    }),
    children: /*#__PURE__*/_react.default.createElement(_summarization_panel.SummarizationPanel, null),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      href: managementLink,
      "data-test-subj": "manageConnectorsLink",
      iconType: "wrench",
      size: "s",
      "aria-label": _i18n.i18n.translate('xpack.searchPlayground.sidebar.summarizationModel.manageConnectorLink', {
        defaultMessage: 'Manage connector'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.sidebar.summarizationModel.manageConnectorTooltip",
      defaultMessage: "Manage"
    }))
  }, {
    title: _i18n.i18n.translate('xpack.searchPlayground.sidebar.contextTitle', {
      defaultMessage: 'Context'
    }),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.context,
      target: "_blank",
      "data-test-subj": "hidden-fields-documentation-link"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.sidebar.contextLearnMore",
      defaultMessage: "Learn more"
    })),
    children: /*#__PURE__*/_react.default.createElement(_edit_context_panel.EditContextPanel, null)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "eui-yScroll",
    gutterSize: "none"
  }, panels === null || panels === void 0 ? void 0 : panels.map(({
    title,
    children,
    extraAction
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: title,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: {
      padding: euiTheme.size.l
    },
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title)), extraAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, extraAction))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children)))));
};
exports.ChatSidebar = ChatSidebar;