"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNotebookList = exports.readNotebookListFromParam = void 0;
var _react = require("react");
var _queryString = require("query-string");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readNotebookListFromParam = () => {
  const [, queryString] = (window.location.search || window.location.hash || '').split('?');
  const queryParams = (0, _queryString.parse)(queryString || '', {
    sort: false
  });
  if (queryParams && queryParams.nblist && typeof queryParams.nblist === 'string') {
    return queryParams.nblist;
  }
  return undefined;
};
exports.readNotebookListFromParam = readNotebookListFromParam;
const useNotebookList = () => {
  const {
    notebooks: {
      getNotebookList
    }
  } = (0, _use_kibana.useKibanaServices)();
  const nbList = (0, _react.useMemo)(() => getNotebookList(), [getNotebookList]);
  const nbListQueryParam = (0, _react.useMemo)(() => readNotebookListFromParam(), []);
  if (nbListQueryParam) return nbListQueryParam;
  if (nbList) return nbList;
  return undefined;
};
exports.useNotebookList = useNotebookList;