"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTrainedModelPageUrl = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTrainedModelPageUrl = () => {
  const {
    services: {
      ml
    }
  } = (0, _use_kibana.useKibana)();
  const [trainedModelPageUrl, setTrainedModelPageUrl] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const fetchMlTrainedModelPageUrl = async () => {
      var _ml$locator;
      const url = await (ml === null || ml === void 0 ? void 0 : (_ml$locator = ml.locator) === null || _ml$locator === void 0 ? void 0 : _ml$locator.getUrl({
        page: 'trained_models'
      }));
      setTrainedModelPageUrl(url);
    };
    fetchMlTrainedModelPageUrl();
  }, [ml]);
  return trainedModelPageUrl;
};
exports.useTrainedModelPageUrl = useTrainedModelPageUrl;