"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectFilter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiSelectFilter = ({
  buttonLabel,
  onChange,
  options: rawOptions,
  selectedOptionKeys = [],
  renderOption,
  dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const toggleIsPopoverOpen = () => setIsPopoverOpen(prevValue => !prevValue);
  const options = _lodash.default.uniqBy(rawOptions.map(({
    key,
    label
  }) => ({
    label,
    key,
    checked: selectedOptionKeys.includes(key) ? 'on' : undefined
  })), 'label');
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
      iconType: 'arrowDown',
      onClick: toggleIsPopoverOpen,
      isSelected: isPopoverOpen,
      numFilters: options.length,
      hasActiveFilters: selectedOptionKeys.length > 0,
      numActiveFilters: selectedOptionKeys.length,
      "aria-label": buttonLabel
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textTruncate"
    }, buttonLabel)),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    options: options,
    searchable: true,
    searchProps: {
      placeholder: buttonLabel
    },
    emptyMessage: "No options",
    onChange: onChange,
    singleSelection: false,
    renderOption: renderOption
  }, (list, search) => /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, search), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                  line-height: ${euiTheme.size.xl};
                  padding-left: ${euiTheme.size.m};
                  border-bottom: ${euiTheme.border.thin};
                `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, i18n.OPTIONS(options.length))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), list))));
};
exports.MultiSelectFilter = MultiSelectFilter;