"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndicesStatus = fetchIndicesStatus;
exports.fetchUserStartPrivileges = fetchUserStartPrivileges;
var _index_utils = require("../utils/index_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchIndicesStatus(client, logger) {
  const indexMatches = await client.indices.get({
    expand_wildcards: ['open'],
    // for better performance only compute settings of indices but not mappings
    features: ['settings'],
    index: '*'
  });
  const indexNames = Object.keys(indexMatches).filter(indexName => indexMatches[indexName] && !(0, _index_utils.isHidden)(indexMatches[indexName]) && !(0, _index_utils.isClosed)(indexMatches[indexName]));
  return {
    indexNames
  };
}
async function fetchUserStartPrivileges(client, logger, indexName = 'test-index-name') {
  try {
    var _securityCheck$index$, _securityCheck$index, _securityCheck$index$2, _securityCheck$cluste, _securityCheck$cluste2;
    const securityCheck = await client.security.hasPrivileges({
      cluster: ['manage_api_key'],
      index: [{
        names: [indexName],
        privileges: ['create_index']
      }]
    });
    return {
      privileges: {
        canCreateIndex: (_securityCheck$index$ = securityCheck === null || securityCheck === void 0 ? void 0 : (_securityCheck$index = securityCheck.index) === null || _securityCheck$index === void 0 ? void 0 : (_securityCheck$index$2 = _securityCheck$index[indexName]) === null || _securityCheck$index$2 === void 0 ? void 0 : _securityCheck$index$2.create_index) !== null && _securityCheck$index$ !== void 0 ? _securityCheck$index$ : false,
        canCreateApiKeys: (_securityCheck$cluste = securityCheck === null || securityCheck === void 0 ? void 0 : (_securityCheck$cluste2 = securityCheck.cluster) === null || _securityCheck$cluste2 === void 0 ? void 0 : _securityCheck$cluste2.manage_api_key) !== null && _securityCheck$cluste !== void 0 ? _securityCheck$cluste : false
      }
    };
  } catch (e) {
    logger.error(`Error checking user privileges for searchIndices elasticsearch start`);
    logger.error(e);
    return {
      privileges: {
        canCreateIndex: false,
        canCreateApiKeys: false
      }
    };
  }
}