"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadIndicesStatusError = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _errors = require("../../utils/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadIndicesStatusError = ({
  error
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.searchIndices.shared.statusFetchError.title', {
      defaultMessage: 'Error loading indices'
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      css: {
        textAlign: 'left'
      }
    }, (0, _errors.getErrorMessage)(error, _i18n.i18n.translate('xpack.searchIndices.shared.statusFetchError.unknownError', {
      defaultMessage: 'Unknown error fetching indices.'
    })))
  });
};
exports.LoadIndicesStatusError = LoadIndicesStatusError;