"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../common/doc_links");
var _use_kibana = require("../../hooks/use_kibana");
var _types = require("../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_WIDTH = '650px';
const CreateIndexPanel = ({
  children,
  createIndexView,
  onChangeView,
  onClose,
  showCallouts,
  showSkip,
  title
}) => {
  const {
    cloud,
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const o11yTrialLink = (0, _react.useMemo)(() => {
    if (cloud && cloud.isServerlessEnabled) {
      var _cloud$projectsUrl;
      const baseUrl = (_cloud$projectsUrl = cloud === null || cloud === void 0 ? void 0 : cloud.projectsUrl) !== null && _cloud$projectsUrl !== void 0 ? _cloud$projectsUrl : 'https://cloud.elastic.co/projects/';
      return `${baseUrl}create/observability/start`;
    }
    return http.basePath.prepend('/app/observability/onboarding');
  }, [cloud, http]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    hasBorder: true,
    style: {
      maxWidth: MAX_WIDTH,
      margin: '0 auto',
      padding: euiTheme.size.l,
      paddingTop: euiTheme.size.m
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "closeCreateIndex",
    iconType: "cross",
    onClick: onClose,
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.closeAriaLabel', {
      defaultMessage: 'Close create index'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "none",
    style: {
      paddingLeft: euiTheme.size.m,
      paddingRight: euiTheme.size.m
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElasticsearch",
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.pageTitle', {
    defaultMessage: 'Elasticsearch'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.pageDescription', {
    defaultMessage: 'Get started with Elasticsearch'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title !== null && title !== void 0 ? title : _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.defaultTitle', {
    defaultMessage: 'Create an index'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.viewSelect.legend', {
      defaultMessage: 'Create index view selection'
    }),
    options: [{
      id: _types.CreateIndexViewMode.UI,
      label: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.viewSelect.ui', {
        defaultMessage: 'UI'
      }),
      'data-test-subj': 'createIndexUIViewBtn'
    }, {
      id: _types.CreateIndexViewMode.Code,
      label: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.viewSelect.code', {
        defaultMessage: 'Code'
      }),
      'data-test-subj': 'createIndexCodeViewBtn'
    }],
    buttonSize: "compressed",
    idSelected: createIndexView,
    onChange: onChangeView
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.description', {
    defaultMessage: 'An index stores your data and defines the schema, or field mappings, for your searches'
  }))), children)), showCallouts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.title', {
    defaultMessage: 'Looking to store your logs or metrics data?'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconSide: "right",
    iconType: "popout",
    "data-test-subj": "analyzeLogsBtn",
    href: _doc_links.docLinks.analyzeLogs,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.logs.button', {
    defaultMessage: 'Collect and analyze logs'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("small", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.logs.subTitle', {
    defaultMessage: 'Explore Logstash and Beats'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "or")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconSide: "right",
    iconType: "popout",
    "data-test-subj": "startO11yTrialBtn",
    href: o11yTrialLink,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.o11yTrial.button', {
    defaultMessage: 'Start an Observability trial'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("small", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.observabilityCallout.o11yTrial.subTitle', {
    defaultMessage: 'Powerful performance monitoring'
  })))))))), showSkip === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "createIndexSkipBtn"
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.skipLabel', {
    defaultMessage: 'Skip'
  })))));
};
exports.CreateIndexPanel = CreateIndexPanel;