"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexloadingError = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexloadingError = ({
  error: {
    title,
    message
  },
  navigateToIndexListPage,
  reloadFunction
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
  "data-test-subj": "pageLoadError",
  color: "danger",
  iconType: "warning",
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.pageLoadError.errorTitle",
    defaultMessage: "{error}",
    values: {
      error: title
    }
  })),
  body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.pageLoadError.description",
    defaultMessage: "{message}",
    values: {
      message
    }
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconType: "arrowLeft",
    onClick: () => navigateToIndexListPage(),
    "data-test-subj": "loadingErrorBackToIndicesButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.pageLoadError.backToIndicesButtonLabel",
    defaultMessage: "Back to indices"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconSide: "right",
    onClick: reloadFunction,
    iconType: "refresh",
    color: "danger",
    "data-test-subj": "reloadButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.pageLoadError.reloadButtonLabel",
    defaultMessage: "Reload"
  }))))
});
exports.IndexloadingError = IndexloadingError;