"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDocuments = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_index_mappings = require("../../hooks/api/use_index_mappings");
var _add_documents_code_example = require("./add_documents_code_example");
var _document_list = require("./document_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexDocuments = ({
  indexName,
  indexDocuments,
  isInitialLoading
}) => {
  var _indexDocuments$resul, _indexDocuments$resul2, _mappingData$mappings, _mappingData$mappings2;
  const {
    data: mappingData
  } = (0, _use_index_mappings.useIndexMapping)(indexName);
  const docs = (_indexDocuments$resul = indexDocuments === null || indexDocuments === void 0 ? void 0 : (_indexDocuments$resul2 = indexDocuments.results) === null || _indexDocuments$resul2 === void 0 ? void 0 : _indexDocuments$resul2.data) !== null && _indexDocuments$resul !== void 0 ? _indexDocuments$resul : [];
  const mappingProperties = (_mappingData$mappings = mappingData === null || mappingData === void 0 ? void 0 : (_mappingData$mappings2 = mappingData.mappings) === null || _mappingData$mappings2 === void 0 ? void 0 : _mappingData$mappings2.properties) !== null && _mappingData$mappings !== void 0 ? _mappingData$mappings : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary"
  }), !isInitialLoading && docs.length === 0 && /*#__PURE__*/_react.default.createElement(_add_documents_code_example.AddDocumentsCodeExample, {
    indexName: indexName,
    mappingProperties: mappingProperties
  }), docs.length > 0 && /*#__PURE__*/_react.default.createElement(_document_list.DocumentList, {
    indexName: indexName,
    docs: docs,
    mappingProperties: mappingProperties
  }))));
};
exports.IndexDocuments = IndexDocuments;