"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PythonServerlessVectorsIngestDataExample = exports.PythonServerlessCreateIndexExamples = exports.PYTHON_INFO = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PYTHON_INFO = exports.PYTHON_INFO = {
  id: 'python',
  title: _i18n.i18n.translate('xpack.searchIndices.codingLanguages.python', {
    defaultMessage: 'Python'
  }),
  icon: 'python.svg',
  codeBlockLanguage: 'python'
};
const SERVERLESS_PYTHON_INSTALL_CMD = 'pip install elasticsearch';
const PythonServerlessCreateIndexExamples = exports.PythonServerlessCreateIndexExamples = {
  default: {
    installCommand: SERVERLESS_PYTHON_INSTALL_CMD,
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
  "${elasticsearchURL}",
  api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

client.indices.create(
  index="${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}"
)`
  },
  dense_vector: {
    installCommand: SERVERLESS_PYTHON_INSTALL_CMD,
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

client.indices.create(
    index="${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}",
    mappings={
        "properties": {
            "vector": {"type": "dense_vector", "dims": 3 },
            "text": {"type": "text"}
        }
    }
)`
  }
};
const serverlessIngestionCommand = ({
  elasticsearchURL,
  apiKey,
  indexName,
  sampleDocuments
}) => `from elasticsearch import Elasticsearch, helpers

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

index_name = "${indexName}"

docs = ${JSON.stringify(sampleDocuments, null, 4)}

bulk_response = helpers.bulk(client, docs, index=index_name)
print(bulk_response)`;
const serverlessUpdateMappingsCommand = ({
  elasticsearchURL,
  apiKey,
  indexName,
  mappingProperties
}) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

index_name = "${indexName}"

mappings = ${JSON.stringify({
  properties: mappingProperties
}, null, 4)}

mapping_response = client.indices.put_mapping(index=index_name, body=mappings)
print(mapping_response)
`;
const PythonServerlessVectorsIngestDataExample = exports.PythonServerlessVectorsIngestDataExample = {
  installCommand: SERVERLESS_PYTHON_INSTALL_CMD,
  ingestCommand: serverlessIngestionCommand,
  updateMappingsCommand: serverlessUpdateMappingsCommand
};