"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchHomepagePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _common = require("../common");
var _embeddable = require("./embeddable");
var _feature_flags = require("./feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const appInfo = {
  id: _common.PLUGIN_ID,
  appRoute: '/app/elasticsearch/home',
  title: _i18n.i18n.translate('xpack.searchHomepage.appTitle', {
    defaultMessage: 'Home'
  })
};
class SearchHomepagePlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup(core) {
    var _this$config$ui;
    const result = {
      app: appInfo,
      isHomepageFeatureEnabled() {
        return (0, _feature_flags.isHomepageEnabled)(core.uiSettings);
      }
    };
    if (!((_this$config$ui = this.config.ui) !== null && _this$config$ui !== void 0 && _this$config$ui.enabled)) return result;
    if (!(0, _feature_flags.isHomepageEnabled)(core.uiSettings)) return result;
    core.application.register({
      ...result.app,
      async mount({
        element,
        history
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, depsStart] = await core.getStartServices();
        const startDeps = {
          ...depsStart,
          history
        };
        return renderApp(coreStart, startDeps, element);
      }
    });
    return result;
  }
  start(core) {
    return {
      app: appInfo,
      isHomepageFeatureEnabled() {
        return (0, _feature_flags.isHomepageEnabled)(core.uiSettings);
      },
      SearchHomepage: _embeddable.SearchHomepage
    };
  }
}
exports.SearchHomepagePlugin = SearchHomepagePlugin;