"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronMonthly = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CronMonthly = ({
  disabled,
  minute,
  minuteOptions,
  hour,
  hourOptions,
  date,
  dateOptions,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchConnectors.cronEditor.cronMonthly.fieldDateLabel",
    defaultMessage: "Date"
  }),
  fullWidth: true,
  "data-test-subj": "cronFrequencyConfiguration"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  disabled: disabled,
  options: dateOptions,
  value: date,
  onChange: e => onChange({
    date: e.target.value
  }),
  fullWidth: true,
  prepend: _i18n.i18n.translate('searchConnectors.cronEditor.cronMonthly.textOnTheLabel', {
    defaultMessage: 'On the'
  }),
  "data-test-subj": "cronFrequencyMonthlyDateSelect"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchConnectors.cronEditor.cronMonthly.fieldTimeLabel",
    defaultMessage: "Time"
  }),
  fullWidth: true,
  "data-test-subj": "cronFrequencyConfiguration"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  disabled: disabled,
  options: hourOptions,
  value: hour,
  "aria-label": _i18n.i18n.translate('searchConnectors.cronEditor.cronMonthly.hourSelectLabel', {
    defaultMessage: 'Hour'
  }),
  onChange: e => onChange({
    hour: e.target.value
  }),
  fullWidth: true,
  prepend: _i18n.i18n.translate('searchConnectors.cronEditor.cronMonthly.fieldHour.textAtLabel', {
    defaultMessage: 'At'
  }),
  "data-test-subj": "cronFrequencyMonthlyHourSelect"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  disabled: disabled,
  options: minuteOptions,
  value: minute,
  "aria-label": _i18n.i18n.translate('searchConnectors.cronEditor.cronMonthly.minuteSelectLabel', {
    defaultMessage: 'Minute'
  }),
  onChange: e => onChange({
    minute: e.target.value
  }),
  fullWidth: true,
  prepend: ":",
  "data-test-subj": "cronFrequencyMonthlyMinuteSelect"
})))));
exports.CronMonthly = CronMonthly;