"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagSearchBarOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TagSearchBarOption = ({
  tag
}) => {
  const {
    name,
    color
  } = tag;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": `tag-searchbar-option-${(0, _utils.testSubjFriendly)(name)}`
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, name)));
};
exports.TagSearchBarOption = TagSearchBarOption;