"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPTIME_RULE_TYPE_IDS = exports.SYNTHETICS_TLS_RULE = exports.SYNTHETICS_STATUS_RULE = exports.SYNTHETICS_RULE_TYPE_IDS = exports.SYNTHETICS_ALERT_RULE_TYPES = exports.STREAMS_RULE_TYPE_IDS = exports.STREAMS_ESQL_RULE_TYPE_ID = exports.SLO_RULE_TYPE_IDS = exports.SLO_BURN_RATE_RULE_TYPE_ID = exports.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID = exports.OBSERVABILITY_RULE_TYPE_IDS = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.LOG_THRESHOLD_ALERT_TYPE_ID = exports.LOG_RULE_TYPE_IDS = exports.InfraRuleType = exports.INFRA_RULE_TYPE_IDS = exports.ApmRuleType = exports.APM_RULE_TYPE_IDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OBSERVABILITY_THRESHOLD_RULE_TYPE_ID = exports.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID = 'observability.rules.custom_threshold';

/**
 * APM rule types
 */
let ApmRuleType = exports.ApmRuleType = /*#__PURE__*/function (ApmRuleType) {
  ApmRuleType["ErrorCount"] = "apm.error_rate";
  ApmRuleType["TransactionErrorRate"] = "apm.transaction_error_rate";
  ApmRuleType["TransactionDuration"] = "apm.transaction_duration";
  ApmRuleType["Anomaly"] = "apm.anomaly";
  return ApmRuleType;
}({});
const APM_RULE_TYPE_IDS = exports.APM_RULE_TYPE_IDS = Object.values(ApmRuleType);

/**
 * Synthetics ryle types
 */

const SYNTHETICS_STATUS_RULE = exports.SYNTHETICS_STATUS_RULE = 'xpack.synthetics.alerts.monitorStatus';
const SYNTHETICS_TLS_RULE = exports.SYNTHETICS_TLS_RULE = 'xpack.synthetics.alerts.tls';
const SYNTHETICS_ALERT_RULE_TYPES = exports.SYNTHETICS_ALERT_RULE_TYPES = {
  MONITOR_STATUS: SYNTHETICS_STATUS_RULE,
  TLS: SYNTHETICS_TLS_RULE
};
const SYNTHETICS_RULE_TYPE_IDS = exports.SYNTHETICS_RULE_TYPE_IDS = [SYNTHETICS_STATUS_RULE, SYNTHETICS_TLS_RULE];

/**
 * SLO rule types
 */
const SLO_BURN_RATE_RULE_TYPE_ID = exports.SLO_BURN_RATE_RULE_TYPE_ID = 'slo.rules.burnRate';
const SLO_RULE_TYPE_IDS = exports.SLO_RULE_TYPE_IDS = [SLO_BURN_RATE_RULE_TYPE_ID];

/**
 * ESQL rule types
 */
const STREAMS_ESQL_RULE_TYPE_ID = exports.STREAMS_ESQL_RULE_TYPE_ID = 'streams.rules.esql';
const STREAMS_RULE_TYPE_IDS = exports.STREAMS_RULE_TYPE_IDS = [STREAMS_ESQL_RULE_TYPE_ID];

/**
 * Metrics rule types
 */
const METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.inventory.threshold';
const METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.threshold';

/**
 * Logs rule types
 */
const LOG_THRESHOLD_ALERT_TYPE_ID = exports.LOG_THRESHOLD_ALERT_TYPE_ID = 'logs.alert.document.count';
const LOG_RULE_TYPE_IDS = exports.LOG_RULE_TYPE_IDS = [LOG_THRESHOLD_ALERT_TYPE_ID];

/**
 * Uptime rule types
 */

const UPTIME_RULE_TYPE_IDS = exports.UPTIME_RULE_TYPE_IDS = ['xpack.uptime.alerts.tls', 'xpack.uptime.alerts.tlsCertificate', 'xpack.uptime.alerts.monitorStatus', 'xpack.uptime.alerts.durationAnomaly'];

/**
 * Infra rule types
 */
let InfraRuleType = exports.InfraRuleType = /*#__PURE__*/function (InfraRuleType) {
  InfraRuleType["MetricThreshold"] = "metrics.alert.threshold";
  InfraRuleType["InventoryThreshold"] = "metrics.alert.inventory.threshold";
  return InfraRuleType;
}({});
const INFRA_RULE_TYPE_IDS = exports.INFRA_RULE_TYPE_IDS = Object.values(InfraRuleType);
const OBSERVABILITY_RULE_TYPE_IDS = exports.OBSERVABILITY_RULE_TYPE_IDS = [...APM_RULE_TYPE_IDS, ...SYNTHETICS_RULE_TYPE_IDS, ...INFRA_RULE_TYPE_IDS, ...UPTIME_RULE_TYPE_IDS, ...LOG_RULE_TYPE_IDS, ...SLO_RULE_TYPE_IDS, OBSERVABILITY_THRESHOLD_RULE_TYPE_ID];