"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCtx = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class Context {
  constructor(opts) {
    var _opts$sharedSchemas;
    (0, _defineProperty2.default)(this, "sharedSchemas", void 0);
    this.sharedSchemas = (_opts$sharedSchemas = opts.sharedSchemas) !== null && _opts$sharedSchemas !== void 0 ? _opts$sharedSchemas : new Map();
  }
  addSharedSchema(id, schema) {
    this.sharedSchemas.set(id, schema);
  }
  getSharedSchemas() {
    return Object.fromEntries(this.sharedSchemas.entries());
  }
}
const createCtx = (opts = {
  sharedSchemas: new Map()
}) => {
  return new Context(opts);
};
exports.createCtx = createCtx;