"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rollupToggleExtension = exports.rollupBadgeExtension = void 0;
var _i18n = require("@kbn/i18n");
var _rollup = require("@kbn/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rollupToggleExtension = exports.rollupToggleExtension = {
  matchIndex: index => {
    return Boolean(index.isRollupIndex);
  },
  label: _i18n.i18n.translate('xpack.rollupJobs.indexMgmtToggle.toggleLabel', {
    defaultMessage: 'Include rollup indices'
  }),
  name: 'rollupToggle'
};
const rollupBadgeExtension = exports.rollupBadgeExtension = {
  matchIndex: index => {
    return Boolean(index.isRollupIndex);
  },
  label: _rollup.ROLLUP_DEPRECATION_BADGE_LABEL,
  color: 'warning',
  filterExpression: 'isRollupIndex:true'
};