"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopJobs = exports.startJobs = void 0;
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _action_types = require("../action_types");
var _refresh_jobs = require("./refresh_jobs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startJobs = jobIds => async dispatch => {
  dispatch({
    type: _action_types.UPDATE_JOB_START
  });
  try {
    await (0, _services.createNoticeableDelay)((0, _services.startJobs)(jobIds));
  } catch (error) {
    dispatch({
      type: _action_types.UPDATE_JOB_FAILURE
    });
    return (0, _services.showApiError)(error, _i18n.i18n.translate('xpack.rollupJobs.startJobsAction.errorTitle', {
      defaultMessage: 'Error starting rollup jobs'
    }));
  }
  dispatch({
    type: _action_types.UPDATE_JOB_SUCCESS
  });
  dispatch((0, _refresh_jobs.refreshJobs)());
};
exports.startJobs = startJobs;
const stopJobs = jobIds => async dispatch => {
  dispatch({
    type: _action_types.UPDATE_JOB_START
  });
  try {
    await (0, _services.createNoticeableDelay)((0, _services.stopJobs)(jobIds));
  } catch (error) {
    dispatch({
      type: _action_types.UPDATE_JOB_FAILURE
    });
    return (0, _services.showApiError)(error, _i18n.i18n.translate('xpack.rollupJobs.stopJobsAction.errorTitle', {
      defaultMessage: 'Error stopping rollup jobs'
    }));
  }
  dispatch({
    type: _action_types.UPDATE_JOB_SUCCESS
  });
  dispatch((0, _refresh_jobs.refreshJobs)());
};
exports.stopJobs = stopJobs;