"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showApiError = showApiError;
exports.showApiWarning = showApiWarning;
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createToastConfig(error, errorTitle) {
  if (error && error.body) {
    // Error body shape is defined by the API.
    const {
      error: errorString,
      statusCode,
      message
    } = error.body;
    return {
      title: errorTitle,
      text: `${statusCode}: ${errorString}. ${message}`
    };
  }
}
function showApiWarning(error, errorTitle) {
  const toastConfig = createToastConfig(error, errorTitle);
  if (toastConfig) {
    return (0, _kibana_services.getNotifications)().toasts.addWarning(toastConfig);
  }

  // This error isn't an HTTP error, so let the fatal error screen tell the user something
  // unexpected happened.
  return (0, _kibana_services.getFatalErrors)().add(error, errorTitle);
}
function showApiError(error, errorTitle) {
  const toastConfig = createToastConfig(error, errorTitle);
  if (toastConfig) {
    return (0, _kibana_services.getNotifications)().toasts.addDanger(toastConfig);
  }

  // This error isn't an HTTP error, so let the fatal error screen tell the user something
  // unexpected happened.
  (0, _kibana_services.getFatalErrors)().add(error, errorTitle);
}