"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRollupPageSize = validateRollupPageSize;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateRollupPageSize(rollupPageSize) {
  if (!rollupPageSize || !rollupPageSize.toString().trim()) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.rollupPageSizeMissing",
      defaultMessage: "Page size is required."
    })];
  }
  if (rollupPageSize <= 0) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.rollupPageSizeGreaterThanZero",
      defaultMessage: "Page size must be greater than zero."
    })];
  }
  return undefined;
}