"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateId = validateId;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateId(id, clonedId) {
  if (clonedId && id === clonedId) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.idSameAsCloned",
      defaultMessage: "Name cannot be the same as cloned name: \"{clonedId}\".",
      values: {
        clonedId
      }
    })];
  }
  if (!id || !id.trim()) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.idMissing",
      defaultMessage: "Name is required."
    })];
  }
  return undefined;
}