"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldChooser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldChooser extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onSearch", e => {
      this.setState({
        searchValue: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(state => ({
        isOpen: !state.isOpen
      }));
    });
    (0, _defineProperty2.default)(this, "close", () => {
      this.setState({
        isOpen: false
      });
    });
    this.state = {
      isOpen: false,
      searchValue: ''
    };
  }
  render() {
    const {
      buttonLabel,
      columns,
      fields,
      selectedFields,
      prompt,
      onSelectField,
      dataTestSubj
    } = this.props;
    const {
      isOpen,
      searchValue
    } = this.state;
    const getRowProps = item => {
      return {
        onClick: () => {
          onSelectField(item);
        }
      };
    };
    const renderFlyout = () => {
      // Derive the fields which the user can select.
      const selectedFieldNames = selectedFields.map(({
        name
      }) => name);
      const unselectedFields = fields.filter(({
        name
      }) => {
        return !selectedFieldNames.includes(name);
      });
      const searchedItems = searchValue ? unselectedFields.filter(item => {
        const normalizedSearchValue = searchValue.trim().toLowerCase();
        return item.name.toLowerCase().includes(normalizedSearchValue) || item.type.toLowerCase().includes(normalizedSearchValue);
      }) : unselectedFields;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        onClose: this.close,
        "aria-labelledby": "fieldChooserFlyoutTitle",
        size: "m",
        maxWidth: 400,
        "data-test-subj": dataTestSubj
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m",
        id: "fieldChooserFlyoutTitle",
        "data-test-subj": "rollupJobCreateFlyoutTitle"
      }, /*#__PURE__*/_react.default.createElement("h2", null, buttonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
        placeholder: prompt,
        value: searchValue,
        onChange: this.onSearch,
        "aria-label": prompt,
        fullWidth: true
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
        items: searchedItems,
        columns: columns,
        rowProps: getRowProps,
        responsive: false,
        "data-test-subj": `${dataTestSubj}-table`
      })));
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.onButtonClick,
      "data-test-subj": "rollupJobShowFieldChooserButton"
    }, buttonLabel), isOpen ? renderFlyout() : null);
  }
}
exports.FieldChooser = FieldChooser;
(0, _defineProperty2.default)(FieldChooser, "propTypes", {
  buttonLabel: _propTypes.default.node.isRequired,
  columns: _propTypes.default.array.isRequired,
  fields: _propTypes.default.array.isRequired,
  selectedFields: _propTypes.default.array.isRequired,
  onSelectField: _propTypes.default.func.isRequired,
  prompt: _propTypes.default.string,
  dataTestSubj: _propTypes.default.string
});
(0, _defineProperty2.default)(FieldChooser, "defaultProps", {
  prompt: 'Search',
  dataTestSubj: 'rollupJobFieldChooser'
});