"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusToHealthMap = {
  stopped: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.jobStatus.stoppedLabel",
    defaultMessage: "Stopped"
  })),
  stopping: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.jobStatus.stoppingLabel",
    defaultMessage: "Stopping"
  })),
  started: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.jobStatus.startedLabel",
    defaultMessage: "Started"
  })),
  indexing: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.jobStatus.indexingLabel",
    defaultMessage: "Indexing"
  })),
  abort: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.jobStatus.abortingLabel",
    defaultMessage: "Aborting"
  }))
};
const statusUnknown = /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.rollupJobs.jobStatus.unknownLabel",
  defaultMessage: "Unknown"
}));
const JobStatus = ({
  status
}) => statusToHealthMap[status] || statusUnknown;
exports.JobStatus = JobStatus;