"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerReportingUsageCollector = registerReportingUsageCollector;
var _rxjs = require("rxjs");
var _collection_schema = require("./collection_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerReportingUsageCollector(reporting, usageCollection) {
  if (!usageCollection) {
    return;
  }
  const isReady = reporting.pluginStartsUp.bind(reporting);
  const getLicense = async () => {
    const {
      licensing
    } = await reporting.getPluginStartDeps();
    return await (0, _rxjs.firstValueFrom)(licensing.license$.pipe((0, _rxjs.map)(({
      isAvailable
    }) => ({
      isAvailable
    }))));
  };
  const collector = usageCollection.makeUsageCollector({
    type: 'reporting',
    fetch: () => getLicense().then(license => {
      return {
        available: license.isAvailable === true,
        // is available under all non-expired licenses
        enabled: true // is enabled, by nature of this code path executing
      };
    }),
    isReady,
    schema: _collection_schema.ReportingSchema
  });
  usageCollection.registerCollector(collector);
}