"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetReportingHealthQuery = exports.getKey = void 0;
var _reactQuery = require("@kbn/react-query");
var _get_reporting_health = require("../apis/get_reporting_health");
var _query_keys = require("../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKey = exports.getKey = _query_keys.queryKeys.getHealth;
const useGetReportingHealthQuery = ({
  http
}) => {
  return (0, _reactQuery.useQuery)({
    queryKey: getKey(),
    queryFn: () => (0, _get_reporting_health.getReportingHealth)({
      http
    })
  });
};
exports.useGetReportingHealthQuery = useGetReportingHealthQuery;