"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduledReportFlyoutShareWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/share-plugin/public");
var _reportingPublic = require("@kbn/reporting-public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _lodash = require("lodash");
var _report_params = require("../report_params");
var _query_client = require("../../query_client");
var _scheduled_report_flyout_content = require("./scheduled_report_flyout_content");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScheduledReportFlyoutShareWrapper = ({
  apiClient,
  services: reportingServices,
  sharingData,
  onClose
}) => {
  const upstreamServices = (0, _reportingPublic.useKibana)().services;
  const services = (0, _react.useMemo)(() => ({
    ...reportingServices,
    ...upstreamServices
  }), [reportingServices, upstreamServices]);
  const {
    shareMenuItems,
    objectType
  } = (0, _public.useShareTypeContext)('integration', 'export');
  const availableReportTypes = (0, _react.useMemo)(() => {
    return shareMenuItems.filter(item => _report_params.supportedReportTypes.includes(item.config.exportType)).map(item => ({
      id: item.config.exportType,
      label: item.config.label
    }));
  }, [shareMenuItems]);
  const scheduledReport = (0, _react.useMemo)(() => ({
    title: sharingData.title
  }), [sharingData]);
  if ((0, _lodash.isEmpty)(reportingServices)) {
    return null;
  }
  if (!availableReportTypes || availableReportTypes.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.SCHEDULED_REPORT_NO_REPORT_TYPES_TITLE,
      color: "warning",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18n.SCHEDULED_REPORT_NO_REPORT_TYPES_MESSAGE)));
  }
  return /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.queryClient
  }, /*#__PURE__*/_react.default.createElement(_scheduled_report_flyout_content.ScheduledReportFlyoutContent, {
    apiClient: apiClient,
    objectType: objectType,
    sharingData: sharingData,
    availableReportTypes: availableReportTypes,
    scheduledReport: scheduledReport,
    onClose: onClose
  })));
};
exports.ScheduledReportFlyoutShareWrapper = ScheduledReportFlyoutShareWrapper;