"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrateIlmPolicyCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ilm_policy_status_context = require("../../../lib/ilm_policy_status_context");
var _ilm_policy_migration_needed_callout = require("./ilm_policy_migration_needed_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrateIlmPolicyCallOut = ({
  toasts
}) => {
  const {
    isLoading,
    recheckStatus,
    status
  } = (0, _ilm_policy_status_context.useIlmPolicyStatus)();
  if (isLoading || !status || status === 'ok') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ilm_policy_migration_needed_callout.IlmPolicyMigrationNeededCallOut, {
    toasts: toasts,
    onMigrationDone: recheckStatus
  })));
};
exports.MigrateIlmPolicyCallOut = MigrateIlmPolicyCallOut;