"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsvSearchSourceExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _generateCsv = require("@kbn/generate-csv");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
var _reportingServer = require("@kbn/reporting-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CsvSearchSourceExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesCsvCommon.CSV_REPORT_TYPE);
    (0, _defineProperty2.default)(this, "name", _reportingExportTypesCsvCommon.CSV_JOB_TYPE);
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesCsvCommon.CSV_JOB_TYPE);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'csv');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_BASIC, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    (0, _defineProperty2.default)(this, "createJob", async jobParams => {
      const pagingStrategy = this.config.csv.scroll.strategy;
      return {
        pagingStrategy,
        ...jobParams
      };
    });
    (0, _defineProperty2.default)(this, "runTask", async ({
      jobId,
      payload: job,
      taskInstanceFields,
      request,
      cancellationToken,
      stream
    }) => {
      const logger = this.logger.get('execute-job');
      const {
        csv: csvConfig
      } = this.config;
      const uiSettings = await this.getUiSettingsClient(request, logger);
      const dataPluginStart = this.startDeps.data;
      const fieldFormatsRegistry = await (0, _reportingServer.getFieldFormats)().fieldFormatServiceFactory(uiSettings);
      const es = this.startDeps.esClient.asScoped(request);
      const searchSourceStart = await dataPluginStart.search.searchSource.asScoped(request);
      const clients = {
        uiSettings,
        data: dataPluginStart.search.asScoped(request),
        es
      };
      const dependencies = {
        searchSourceStart,
        fieldFormatsRegistry
      };
      const csv = new _generateCsv.CsvGenerator(job, csvConfig, taskInstanceFields, clients, dependencies, cancellationToken, logger, stream, jobId);
      return await csv.generateData();
    });
    this.logger = this.logger.get('csv-searchsource-export');
  }
}
exports.CsvSearchSourceExportType = CsvSearchSourceExportType;