"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../services/documentation");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
var _breadcrumb = require("../../services/breadcrumb");
var _remote_cluster_table = require("./remote_cluster_table");
var _detail_panel = require("./detail_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_RATE_MS = 30000;
class RemoteClusterList extends _react.Component {
  componentDidUpdate() {
    const {
      openDetailPanel,
      closeDetailPanel,
      isDetailPanelOpen,
      history: {
        location: {
          search
        }
      }
    } = this.props;
    const {
      cluster: clusterName
    } = (0, _shared_imports.extractQueryParams)(search);

    // Show deeplinked remoteCluster whenever remoteClusters get loaded or the URL changes.
    if (clusterName != null) {
      openDetailPanel(clusterName);
    } else if (isDetailPanelOpen) {
      closeDetailPanel();
    }
  }
  componentDidMount() {
    this.props.loadClusters();
    this.interval = setInterval(this.props.refreshClusters, REFRESH_RATE_MS);
    (0, _breadcrumb.setBreadcrumbs)('home');
  }
  componentWillUnmount() {
    clearInterval(this.interval);
  }
  renderBlockingAction() {
    const {
      isCopyingCluster,
      isRemovingCluster
    } = this.props;
    if (isCopyingCluster || isRemovingCluster) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoKibana",
        size: "xl"
      }));
    }
    return null;
  }
  renderNoPermission() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.noPermissionTitle",
        defaultMessage: "Permission error"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.noPermissionText",
        defaultMessage: "You do not have permission to view or add remote clusters."
      }))
    });
  }
  renderError(error) {
    // We can safely depend upon the shape of this error coming from http service, because we
    // handle unexpected error shapes in the API action.
    const {
      statusCode,
      error: errorString
    } = error.body;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.loadingErrorTitle",
        defaultMessage: "Error loading remote clusters"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, statusCode, " ", errorString)
    });
  }
  renderEmpty() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "remoteClusterListEmptyPrompt",
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.emptyPromptTitle",
        defaultMessage: "Add your first remote cluster"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.emptyPromptDescription",
        defaultMessage: "Remote clusters create a uni-directional connection from your local cluster to other clusters."
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, '/add'), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "remoteClusterEmptyPromptCreateButton"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.emptyPrompt.connectButtonLabel",
        defaultMessage: "Add a remote cluster"
      })),
      footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxs"
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusters.emptyState.docsDescription",
        defaultMessage: "Want to learn more?"
      }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.remoteClustersUrl,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusters.emptyState.docsLink",
        defaultMessage: "Read documentation"
      })))
    });
  }
  renderLoading() {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      "data-test-subj": "remoteClustersTableLoading"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterList.loadingTitle",
      defaultMessage: "Loading remote clusters\u2026"
    }));
  }
  renderList() {
    const {
      clusters
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      "data-test-subj": "remote-clusters-list"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterListTitle",
        defaultMessage: "Remote Clusters"
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: _documentation.remoteClustersUrl,
        target: "_blank",
        iconType: "question",
        "data-test-subj": "documentationLink"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClustersDocsLinkText",
        defaultMessage: "Remote Clusters docs"
      }))]
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_remote_cluster_table.RemoteClusterTable, {
      clusters: clusters
    }), /*#__PURE__*/_react.default.createElement(_detail_panel.DetailPanel, null)));
  }
  render() {
    const {
      isLoading,
      clusters,
      clusterLoadError
    } = this.props;
    const isEmpty = !isLoading && !clusters.length;
    const isAuthorized = !clusterLoadError || clusterLoadError.status !== 403;
    let content;
    if (clusterLoadError) {
      if (!isAuthorized) {
        content = this.renderNoPermission();
      } else {
        content = this.renderError(clusterLoadError);
      }
    } else if (isEmpty) {
      content = this.renderEmpty();
    } else if (isLoading) {
      content = this.renderLoading();
    } else {
      content = this.renderList();
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content, this.renderBlockingAction());
  }
}
exports.RemoteClusterList = RemoteClusterList;
(0, _defineProperty2.default)(RemoteClusterList, "propTypes", {
  loadClusters: _propTypes.default.func.isRequired,
  refreshClusters: _propTypes.default.func.isRequired,
  openDetailPanel: _propTypes.default.func.isRequired,
  closeDetailPanel: _propTypes.default.func.isRequired,
  isDetailPanelOpen: _propTypes.default.bool,
  clusters: _propTypes.default.array,
  isLoading: _propTypes.default.bool,
  isCopyingCluster: _propTypes.default.bool,
  isRemovingCluster: _propTypes.default.bool
});