"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStorageDetailsGroupedByIndex = getStorageDetailsGroupedByIndex;
var _lodash = require("lodash");
var _storage_explorer = require("../../../common/storage_explorer");
var _get_indices_stats = require("./get_indices_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getGroupedIndexName(indexName) {
  if (indexName.indexOf('events') > 0) {
    return 'events';
  }
  if (indexName.indexOf('stackframes') > 0) {
    return 'stackframes';
  }
  if (indexName.indexOf('stacktraces') > 0) {
    return 'stacktraces';
  }
  if (indexName.indexOf('executables') > 0) {
    return 'executables';
  }
  if (indexName.indexOf('metrics') > 0) {
    return 'metrics';
  }
}
async function getStorageDetailsGroupedByIndex({
  client,
  indexLifecyclePhase
}) {
  const [indicesStats, indicesLifecycleStatus] = await Promise.all([(0, _get_indices_stats.getIndicesStats)({
    client,
    indices: _get_indices_stats.stacktracesIndices
  }), (0, _get_indices_stats.getIndicesLifecycleStatus)({
    client,
    indices: _get_indices_stats.stacktracesIndices
  })]);
  const indices = indicesStats.indices || {};
  const groupedIndexStatsMap = (0, _lodash.groupBy)(Object.keys(indices).filter(indexName => {
    const indexLifecycleStatus = indicesLifecycleStatus[indexName];
    const currentIndexLifecyclePhase = indexLifecycleStatus && 'phase' in indexLifecycleStatus ? indexLifecycleStatus.phase : undefined;
    if (indexLifecyclePhase !== _storage_explorer.IndexLifecyclePhaseSelectOption.All && currentIndexLifecyclePhase && currentIndexLifecyclePhase !== indexLifecyclePhase) {
      return false;
    }
    return true;
  }).map(indexName => {
    var _indexStats$total, _indexStats$total$doc, _indexStats$total2, _indexStats$total2$st;
    const indexStats = indices[indexName];
    const indexDocCount = ((_indexStats$total = indexStats.total) === null || _indexStats$total === void 0 ? void 0 : (_indexStats$total$doc = _indexStats$total.docs) === null || _indexStats$total$doc === void 0 ? void 0 : _indexStats$total$doc.count) || 0;
    const indexSizeInBytes = ((_indexStats$total2 = indexStats.total) === null || _indexStats$total2 === void 0 ? void 0 : (_indexStats$total2$st = _indexStats$total2.store) === null || _indexStats$total2$st === void 0 ? void 0 : _indexStats$total2$st.size_in_bytes) || 0;
    return {
      indexName: getGroupedIndexName(indexName),
      docCount: indexDocCount,
      sizeInBytes: indexSizeInBytes
    };
  }), 'indexName');
  return Object.keys(groupedIndexStatsMap).map(indexName => {
    const values = groupedIndexStatsMap[indexName];
    const docCount = (0, _lodash.sumBy)(values, 'docCount');
    const sizeInBytes = (0, _lodash.sumBy)(values, 'sizeInBytes');
    return {
      indexName,
      docCount,
      sizeInBytes
    };
  });
}