"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexLifecyclePhaseSelect = IndexLifecyclePhaseSelect;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _storage_explorer = require("../../../common/storage_explorer");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// import * as urlHelpers from '../../shared/links/url_helpers';

function IndexLifecyclePhaseSelect() {
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    indexLifecyclePhase
  } = query;
  const options = [{
    value: _storage_explorer.IndexLifecyclePhaseSelectOption.All,
    label: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.all.label', {
      defaultMessage: 'All'
    }),
    description: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.all.description', {
      defaultMessage: 'Search data in all lifecycle phases.'
    })
  }, {
    value: _storage_explorer.IndexLifecyclePhaseSelectOption.Hot,
    label: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.hot.label', {
      defaultMessage: 'Hot'
    }),
    description: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.hot.description', {
      defaultMessage: 'Holds your most-recent, most-frequently-searched data.'
    })
  }, {
    value: _storage_explorer.IndexLifecyclePhaseSelectOption.Warm,
    label: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.warm.label', {
      defaultMessage: 'Warm'
    }),
    description: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.warm.description', {
      defaultMessage: 'Holds data from recent weeks. Updates are still allowed, but likely infrequent.'
    })
  }, {
    value: _storage_explorer.IndexLifecyclePhaseSelectOption.Cold,
    label: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.cold.label', {
      defaultMessage: 'Cold'
    }),
    description: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.cold.description', {
      defaultMessage: 'While still searchable, this tier is typically optimized for lower storage costs rather than search speed.'
    })
  }, {
    value: _storage_explorer.IndexLifecyclePhaseSelectOption.Frozen,
    label: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.frozen.label', {
      defaultMessage: 'Frozen'
    }),
    description: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.frozen.description', {
      defaultMessage: 'Holds data that are no longer being queried, or being queried rarely.'
    })
  }].map(({
    value,
    label,
    description
  }) => ({
    value,
    inputDisplay: label,
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, description)))
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    prepend: _i18n.i18n.translate('xpack.profiling.storageExplorer.indexLifecyclePhase.label', {
      defaultMessage: 'Index lifecycle phase'
    }),
    options: options,
    valueOfSelected: indexLifecyclePhase,
    onChange: value => {
      profilingRouter.push('/storage-explorer', {
        path: {},
        query: {
          ...query,
          indexLifecyclePhase: value
        }
      });
    },
    hasDividers: true,
    style: {
      minWidth: 200
    }
  });
}