"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutoAbortedHttpClient = useAutoAbortedHttpClient;
var _react = require("react");
var _use_profiling_dependencies = require("../components/contexts/profiling_dependencies/use_profiling_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HTTP_METHODS = ['fetch', 'get', 'post', 'put', 'delete', 'patch'];
function useAutoAbortedHttpClient(dependencies) {
  const controller = (0, _react.useRef)(new AbortController());
  const {
    start: {
      core: {
        http
      }
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const httpClient = (0, _react.useMemo)(() => {
    controller.current.abort();
    controller.current = new AbortController();
    const autoAbortedMethods = {};
    for (const key of HTTP_METHODS) {
      autoAbortedMethods[key] = (path, options) => {
        return http[key](path, {
          ...options,
          signal: controller.current.signal
        }).catch(err => {
          if (err.name === 'AbortError') {
            // return never-resolving promise
            return new Promise(() => {});
          }
          throw err;
        });
      };
    }
    return {
      ...http,
      ...autoAbortedMethods
    };

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [http, ...dependencies]);
  (0, _react.useEffect)(() => {
    return () => {
      controller.current.abort();
    };
  }, []);
  return httpClient;
}