"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphTooltip = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _as_cost = require("../../utils/formatters/as_cost");
var _as_percentage = require("../../utils/formatters/as_percentage");
var _as_weight = require("../../utils/formatters/as_weight");
var _as_integer = require("../../utils/formatters/as_integer");
var _cpu_label_with_hint = require("../cpu_label_with_hint");
var _tooltip_row = require("./tooltip_row");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraphTooltipComponent({
  annualCO2KgsInclusive,
  annualCostsUSDInclusive,
  baselineScaleFactor,
  comparisonAnnualCO2KgsInclusive,
  comparisonAnnualCostsUSDInclusive,
  comparisonCountExclusive,
  comparisonCountInclusive,
  comparisonScaleFactor,
  comparisonTotalSamples,
  comparisonTotalSeconds,
  countExclusive,
  countInclusive,
  inline,
  isRoot,
  label,
  onShowMoreClick,
  parentLabel,
  totalSamples,
  totalSeconds
}) {
  const theme = (0, _eui.useEuiTheme)();
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  const impactEstimates = calculateImpactEstimates({
    countExclusive,
    countInclusive,
    totalSamples,
    totalSeconds
  });
  const comparisonImpactEstimates = (0, _lodash.isNumber)(comparisonCountExclusive) && (0, _lodash.isNumber)(comparisonCountInclusive) && (0, _lodash.isNumber)(comparisonTotalSamples) && (0, _lodash.isNumber)(comparisonTotalSeconds) ? calculateImpactEstimates({
    countExclusive: comparisonCountExclusive,
    countInclusive: comparisonCountInclusive,
    totalSamples: comparisonTotalSamples,
    totalSeconds: comparisonTotalSeconds
  }) : undefined;
  return /*#__PURE__*/_react2.default.createElement(_charts.TooltipContainer, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, label))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      background: theme.euiTheme.border.color
    }
  }), inline && /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    css: (0, _react.css)`
                p {
                  display: flex;
                }
              `,
    color: "primary",
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.inlineCallout', {
      defaultMessage: 'This function has been inlined by {parentLabel}',
      values: {
        parentLabel
      }
    })),
    size: "s",
    iconType: "info"
  }), isRoot === false && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: /*#__PURE__*/_react2.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "total",
      labelSize: "xs",
      iconSize: "s",
      labelStyle: {
        fontWeight: 'bold'
      }
    }),
    value: impactEstimates.totalCPU.percentage,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.totalCPU.percentage,
    formatValue: _as_percentage.asPercentage,
    showDifference: true,
    formatDifferenceAsPercentage: true
  }), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: /*#__PURE__*/_react2.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "self",
      labelSize: "xs",
      iconSize: "s",
      labelStyle: {
        fontWeight: 'bold'
      }
    }),
    value: impactEstimates.selfCPU.percentage,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.selfCPU.percentage,
    showDifference: true,
    formatDifferenceAsPercentage: true,
    formatValue: _as_percentage.asPercentage
  })), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.samplesLabel', {
      defaultMessage: `Samples`
    }),
    value: (0, _lodash.isNumber)(baselineScaleFactor) ? countInclusive * baselineScaleFactor : countInclusive,
    comparison: (0, _lodash.isNumber)(comparisonCountInclusive) && (0, _lodash.isNumber)(comparisonScaleFactor) ? comparisonCountInclusive * comparisonScaleFactor : undefined,
    formatValue: _as_integer.asInteger,
    showDifference: true,
    formatDifferenceAsPercentage: false
  }), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.annualizedCo2', {
      defaultMessage: `Annualized CO2`
    }),
    value: annualCO2KgsInclusive,
    comparison: comparisonAnnualCO2KgsInclusive,
    formatValue: value => (0, _as_weight.asWeight)(value, 'kgs'),
    showDifference: true,
    formatDifferenceAsPercentage: false
  }), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.annualizedDollarCost', {
      defaultMessage: `Annualized dollar cost`
    }),
    value: annualCostsUSDInclusive,
    comparison: comparisonAnnualCostsUSDInclusive,
    formatValue: _as_cost.asCost,
    showDifference: true,
    formatDifferenceAsPercentage: false
  }), onShowMoreClick && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      background: theme.euiTheme.border.color
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "profilingFlameGraphTooltipButton",
    size: "s",
    iconType: "inspect",
    onClick: onShowMoreClick
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.showMoreButton', {
    defaultMessage: `Show more information`
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "info"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.rightClickTip', {
    defaultMessage: `Right-click to pin tooltip`
  })))))))));
}

// Memoize the component to prevent re-renders when props haven't changed
// This was added to prevents recalculation when mouse moves but tooltip data is the same
const arePropsEqual = (prevProps, nextProps) => {
  return (0, _lodash.isEqual)((0, _lodash.omit)(prevProps, 'onShowMoreClick'), (0, _lodash.omit)(nextProps, 'onShowMoreClick'));
};
const FlameGraphTooltip = exports.FlameGraphTooltip = /*#__PURE__*/(0, _react2.memo)(FlameGraphTooltipComponent, arePropsEqual);